// static branches, good for ATI, indifferently for NVidia
vec4 Blend(in vec4 a, in vec4 b, in ivec2 blend)
{
	vec4 s, d;

	// source factor
//if (blend.x == 2)				// GLS_SRCBLEND_ONE (default)
	s = a;		// shut up compiler :(
	if (blend.x == 1)	s = vec4(0.0);		// GLS_SRCBLEND_ZERO
	if (blend.x == 3)	s = a * b;		// GLS_SRCBLEND_DST_COLOR
	if (blend.x == 4)	s = a * (1.0 - b);	// GLS_SRCBLEND_ONE_MINUS_DST_COLOR
	if (blend.x == 5)	s = a * a.a;		// GLS_SRCBLEND_SRC_ALPHA
	if (blend.x == 6)	s = a * (1.0 - a.a);	// GLS_SRCBLEND_ONE_MINUS_SRC_ALPHA
	if (blend.x == 7)	s = a * b.a;		// GLS_SRCBLEND_DST_ALPHA
	if (blend.x == 8)	s = a * (1.0 - b.a);	// GLS_SRCBLEND_ONE_MINUS_DST_ALPHA
	if (blend.x == 9)	s = vec4(a.rgb * min(a.a, 1.0 - b.a), 1.0);	// GLS_SRCBLEND_ALPHA_SATURATE

	// destination factor
//if (blend.y == 1)				// GLS_DSTBLEND_ZERO (default)
	d = vec4(0.0);	// shut up compiler :(
	if (blend.y == 2)	d = b;			// GLS_DSTBLEND_ONE
	if (blend.y == 3)	d = b * a;		// GLS_DSTBLEND_SRC_COLOR
	if (blend.y == 4)	d = b * (1.0 - a);	// GLS_DSTBLEND_ONE_MINUS_SRC_COLOR
	if (blend.y == 5)	d = b * a.a;		// GLS_DSTBLEND_SRC_ALPHA
	if (blend.y == 6)	d = b * (1.0 - a.a);	// GLS_DSTBLEND_ONE_MINUS_SRC_ALPHA
	if (blend.y == 7)	d = b * b.a;		// GLS_DSTBLEND_DST_ALPHA
	if (blend.y == 8)	d = b * (1.0 - b.a);	// GLS_DSTBLEND_ONE_MINUS_DST_ALPHA

	// blend
	return clamp(s + d, 0.0, 1.0);
}
